package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteDao;
import com.ejie.ab04b.model.Tramite;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0489s00ServiceImpl generated by UDA, 06-Feb-2017 12:46:17.
 * 
 * @author UDA
 */

@Service(value = "ab0489s00Service")
public class TramiteServiceImpl implements TramiteService {

	@Autowired()
	private TramiteDao ab0489s00Dao;

	/**
	 * Inserts a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite add(Tramite ab0489s00) {
		return this.ab0489s00Dao.add(ab0489s00);
	}

	/**
	 * Updates a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite update(Tramite ab0489s00) {
		return this.ab0489s00Dao.update(ab0489s00);
	}

	/**
	 * Finds a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @return the tramite
	 */
	public Tramite find(Tramite ab0489s00) {
		return (Tramite) this.ab0489s00Dao.find(ab0489s00);
	}

	/**
	 * Finds a single row in the Ab0489s00 table.
	 * 
	 *  proceedingId
	 *            String
	 *  procedureId
	 *            String
	 *  Tramite
	 *
	 * @param proceedingId the proceeding id
	 * @param procedureId the procedure id
	 * @return the tramite
	 */
	public Tramite findByProceedingIdProcedureId(String proceedingId,
			String procedureId) {
		return (Tramite) this.ab0489s00Dao
				.findByProceedingIdProcedureId(proceedingId, procedureId);
	}

	/**
	 * Deletes a single row in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tramite ab0489s00) {
		this.ab0489s00Dao.remove(ab0489s00);
	}

	/**
	 * Finds a list of rows in the Ab0489s00 table.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0489s00>
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Tramite> findAll(Tramite ab0489s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Tramite>) this.ab0489s00Dao.findAll(ab0489s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0489s00 table using like.
	 * 
	 *  ab0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0489s00>
	 *
	 * @param ab0489s00 the ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Tramite> findAllLike(Tramite ab0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Tramite>) this.ab0489s00Dao.findAllLike(ab0489s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0489s00>
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Tramite> filter(Tramite filterAb0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Tramite> listaAb0489s00 = this.ab0489s00Dao
				.findAllLike(filterAb0489s00, jqGridRequestDto, false);
		Long recordNum = this.ab0489s00Dao.findAllLikeCount(
				filterAb0489s00 != null ? filterAb0489s00 : new Tramite(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Tramite>> reorderSelection = this.ab0489s00Dao
					.reorderSelection(filterAb0489s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Tramite>(jqGridRequestDto, recordNum,
					listaAb0489s00, reorderSelection);
		}
		return new JQGridResponseDto<Tramite>(jqGridRequestDto, recordNum,
				listaAb0489s00);
	}

	/**
	 * Searches rows in the Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  searchAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0489s00>>
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param searchAb0489s00 the search ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Tramite>> search(Tramite filterAb0489s00,
			Tramite searchAb0489s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0489s00Dao.search(filterAb0489s00, searchAb0489s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0489s00 table.
	 * 
	 *  filterAb0489s00
	 *            Ab0489s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0489s00 the filter ab 0489 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Tramite filterAb0489s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0489s00Dao.reorderSelection(filterAb0489s00,
				jqGridRequestDto, startsWith);
	}

}
